-- EDIAQI estrazione dati netpid 
-- 2026/02/09
select count(*) from public."OBSERVATIONS_OFFSET" 
	where "PHENOMENON_TIME_START" <= '2025-12-31 23:55:00'
-- 47625828

-- riaccensioni_prime_tre_osservazioni
select count(*) from riaccensioni_prime_tre_osservazioni
	where "PHENOMENON_TIME_START" <= '2025-12-31 23:55:00';
-- 185247

-- obs escluse
select count(*) 
from public."OBSERVATIONS_OFFSET" obs
JOIN "DATASTREAMS" ds ON ds."ID" = obs."DATASTREAM_ID"
where obs."PHENOMENON_TIME_START" <= '2025-12-31 23:55:00'
AND ds."NAME" in ('PM2.5@THI.FE.030', 'O3@THI.FE.007', 'NO2@THI.FE.015')
AND not obs."ID" in (select "ID" from riaccensioni_prime_tre_osservazioni)
-- 290232

-- 47150349 n_observations (tot obs - riaccensioni - escluse)

-- elenco things_netpid
select "ID", 
	"PROPERTIES"->>'localIdentifier'::text as netpid, 
	"ID" || '_' || ("PROPERTIES"->>'localIdentifier'::text) as file_name
FROM "THINGS"
order by "ID"

THI.FE.001_LS0623020122
THI.FE.002_LS0623020123
THI.FE.003_LS0623020124
THI.FE.004_LS0623020125
THI.FE.005_LS0623020126
THI.FE.006_LS0623020127
THI.FE.007_LS0623020128
THI.FE.008_LS0623020129
THI.FE.009_LS0623020130
THI.FE.010_LS0623020132
THI.FE.011_LS0623020133
THI.FE.012_LS0623020134
THI.FE.013_LS0623020135
THI.FE.014_LS0623020136
THI.FE.015_LS0623020137
THI.FE.016_LS0623020138
THI.FE.017_LS0623020139
THI.FE.018_LS0623020140
THI.FE.019_LS0623020141
THI.FE.020_LS0623020142
THI.FE.021_LS0623020143
THI.FE.022_LS0623020144
THI.FE.023_LS0623020145
THI.FE.024_LS0623020146
THI.FE.025_LS0623020147
THI.FE.026_LS0623020148
THI.FE.027_LS0623020152
THI.FE.028_LS0623020153
THI.FE.029_LS0623020154
THI.FE.030_LS0623020160
THI.FE.031_LS0623020161
THI.FE.032_LS0623020162
THI.FE.033_LS0623020163
THI.FE.034_LS0623020164
THI.FE.035_LS0623020165
THI.FE.036_LS0623020166

--Query ripetuta 36 volte per tutte le centraline.
SELECT th."PROPERTIES"->>'localIdentifier'::text as NETPID, 
       ds."THING_ID",
	   ds."ID" AS "DATASTREAM_ID",
	   ds."NAME" AS "DATASTREAM_NAME",
       obs."PHENOMENON_TIME_START", 
       obs."PHENOMENON_TIME_END",
	   obs."RESULT_TIME",
	   obs."RESULT_NUMBER" ,
	 ds."UNIT_SYMBOL" as "UNIT_OF_MEASURE"
FROM "OBSERVATIONS_OFFSET" obs
JOIN "DATASTREAMS" ds ON ds."ID" = obs."DATASTREAM_ID"
JOIN "THINGS" th ON th."ID" = ds."THING_ID"
WHERE th."ID" = 'THI.FE.036' -- ID da modificare per ciascuna centralina
AND not obs."ID" in (select "ID" from riaccensioni_prime_tre_osservazioni)
AND ds."NAME" not in ('PM2.5@THI.FE.030', 'O3@THI.FE.007', 'NO2@THI.FE.015')
AND obs."PHENOMENON_TIME_START" <= '2025-12-31 23:55:00'

-- osservazioni da eliminare per tutta la serie temporale 
- PM2.5 via Marconi URP - Netpid160 - THI.FE.030 - DATASTREAMS.NAME = 'PM2.5@THI.FE.030'
- O3 via Maverna ufficioFranco second floor  - NetPid 128 - THI.FE.007 - DATASTREAMS.NAME = 'O3@THI.FE.007'
- NO2 Carducci - NetPid137 - THI.FE.015 - DATASTREAMS.NAME = 'NO2@THI.FE.015'
--> ds."NAME" not in ('PM2.5@THI.FE.030', 'O3@THI.FE.007', 'NO2@THI.FE.015')

-- count 
SELECT th."PROPERTIES"->>'localIdentifier'::text as NETPID, 
       ds."THING_ID", count(*)
FROM "OBSERVATIONS_OFFSET" obs
JOIN "DATASTREAMS" ds ON ds."ID" = obs."DATASTREAM_ID"
JOIN "THINGS" th ON th."ID" = ds."THING_ID"
WHERE not obs."ID" in (select "ID" from riaccensioni_prime_tre_osservazioni)
AND ds."NAME" not in ('PM2.5@THI.FE.030', 'O3@THI.FE.007', 'NO2@THI.FE.015')
AND obs."PHENOMENON_TIME_START" <= '2025-12-31 23:55:00'
group by netpid, ds."THING_ID"
order by ds."THING_ID"
-- tot 47.150.349

