# Progetto EDIAQI

| Sito di progetto | https://ediaqi.eu/ |
| ---------------- | ----------------------------- |
| Scheda wiki | [Redmine Deda Next](https://redmine-ps.dedagroup.it/projects/ediaqi/wiki/Wiki) |

--------------------------------------------------------------------------------------------------------

[[_TOC_]]

-------------------------------------------------------------------------------------------------------
## strumenti_monitoraggio

La cartella contiene strumenti di monitoraggio per un controllo rapido delle osservazioni disponibili per ogni Thing nel database FROST di Lab Service.

### script_ediaqi.txt

Il file contiene query SQL e API per monitorare lo stato di caricamento delle serie storiche di osservazioni nel database FROST di Lab Service. Il monitoraggio può essere effettuato interrogando il database tramite query SQL o utilizzando le API. Ogni query presenta una breve descrizione della sua finalità.

### monitor.html
La dashboard visualizza un elenco delle Locations registrate presso l'endpoint STA di LabService e analizza lo stato dei datastream collegati, assumendo che ogni Location abbia una sola Thing. È presente una tabella contenente
la lista delle Locations, i Datastreams disponibili, quelli in ritardo per ogni Location e lo stato. Inoltre, è possibile accedere a un dettaglio specifico per ogni singola Location, cliccando sul nome della Location.

### monitor_dettagli.html
Questa pagina mostra una lista delle proprietà osservate per ogni Thing (Location). Viene visualizzato il primo e l'ultimo datastream disponibile, cioè i timestamp della prima e dell'ultima misura registrata nel database FROST LabService. È anche presente una colonna che indica il ritardo accettabile, che non dovrebbe superare le 2,5 ore in condizioni di normale funzionalità.


## python_DinamicData
### Script caricamento dati dinamici

Lo script si occupa del caricamento dei dati dinamici sul server FROST di Lab Service.
La chiamata viene eseguita indicando il parametro (in giorni) che definisce la massima ampiezza temporate su cui interrogare l’API AWS:

```python frost_data_sync_2.2.py 5```

Lo script si appoggia su di un file parameters, di configurazione, contenuto all'interno della cartella Data, che ha la seguente struttura:
```
[aws_credentials]
aws_access_key_id = <da compilare>
aws_secret_access_key = <da compilare>
[frost]
username = <da compilare>
password = <da compilare>
server_url = https://frost.labservice.it/FROST-Server/v1.1/
[files]
log_path = ./data/
log_filename = log.csv
log_frost_filename = log_inserimenti.csv
mapping_path = ./data/
mapping_filename = datastreams.csv
```
Il file “datastreams.csv” è un file di input che serve per mappare gli ID “locali” di LAS di sensori e parametri negli ID dei datastreams usati nel server FROST.

I file “log.csv” e “log_inserimenti.csv” vengono generati dallo script al momento della prima esecuzione e servono per seguire l’esito delle operazioni.
Si riempiono in append e mantengono quindi traccia di ciascuna delle esecuzioni passate. 


### Script check dati centraline dall'API AWS

#### Esempio di utilizzo

Lo script recupera le risposte dell'API AWS per la centralina specificata e l'intervallo di tempo desiderato (in formato UNIX).  

Lo script viene lanciato senza specificare parametri:

```python amazon_ed.py```

Prima di eseguire lo script, è necessario modificare la variabile request_parameters all'interno dello script con i valori desiderati.
#### Esempio di `request_parameters`:

request_parameters = 'machineSN=LS0623020166&tsFrom=1728517200&tsTo=1728608100'

### Script recupero del pregresso

Lo script permette di recuperare le osservazioni pregresse per un intervallo di giorni specificato, interrogando l’API AWS.  
Si basa sugli stessi file di configurazione `parameters` e `datastreams.csv` utilizzati da `frost_data_sync_2.2.py`.  

Per lanciare il recupero delle osservazioni, si può utilizzare il comando:

```sh batch_insert ```

Il file batch_insert ha la seguente struttura:

```
echo -n INIZIO BATCH
python frost_sync_pregresso_v1.2.py LS0623020122 1/08/2023 31/08/2023 2
python frost_sync_pregresso_v1.2.py LS0623020122 1/09/2023 30/09/2023 2
python frost_sync_pregresso_v1.2.py LS0623020122 1/10/2023 31/10/2023 2
echo FINE BATCH.
```
Per ogni esecuzione dello script, è necessario specificare:

- La centralina per cui si desidera recuperare le osservazioni;
- L’intervallo di tempo per cui si vogliono ottenere i dati;
- Il parametro "giorni", che definisce l’ampiezza temporale della richiesta.

Le osservazioni recuperate verranno direttamente caricate su FROST di Lab Service.

--------------------------------------------------------------------------------------------------------

## python_StaticData

#### Generazione dei JSON statici per la creazione delle entità su FROST  

Gli script generano i file JSON statici, utilizzabili con **POSTMAN**, per la creazione delle entità di base su **FROST** dei vari pilot del progetto.  

#### Entità di base da creare (una tantum):  
- **Things**  
- **Locations**  
- **Feature of Interest (FOI)**  
- **Observed Properties**  
- **Datastreams**  

#### Procedura di esecuzione  
Gli script si basano su file **Excel**, quindi prima di eseguirli è necessario:  
1. **Avviare un'istanza di Jupyter Notebook.**  
2. **Eseguire il run di ogni cella dello script.**  
3. **Specificare nelle celle i percorsi corretti** dei file Excel compilati inizialmente da ogni pilot.  

#### Differenze tra i pilot  
- **Siviglia**: la geometria delle **location** è rappresentata da una **MultiLineString**.  
- **Vilnius**: la geometria può essere di tipo **Point** o **Polygon**, a seconda dei casi.  

#### Personalizzazioni e modifiche  
- È possibile **modificare i nomi dei file di output**.  
- Potrebbe essere necessario **aggiornare gli ID univoci**, ad esempio cambiando `"THI.FE.001"` in `"THI.ZG.001"`.  
- È importante **aggiornare i counter** per mantenere la coerenza dei dati.
- E' importante modificare l'indicazione del sensore nella creazione dei Datastreams.  
